
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

#define MAX_PACKET_SIZE 1024

typedef struct {
  int sequence_number;
  char data[MAX_PACKET_SIZE];
} Packet;

int main() {
  int sockfd;
  struct sockaddr_in server_addr;
  Packet packet;

  
  sockfd = socket(AF_INET, SOCK_DGRAM, htons(8));
  if (sockfd < 0) {
    perror("Error creating socket");
    exit(1);
  }

  
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(5000);
  if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("Error connecting to server");
    exit(1);
  }

  
  packet.sequence_number = 0;
  while (1) {
    
    packet.data[0] = 'A' + packet.sequence_number;
    send(sockfd, &packet, sizeof(packet), 0);

    
    recv(sockfd, &packet, sizeof(packet), 0);

    
    printf("Received packet: sequence number %d, data %c\n", packet.sequence_number, packet.data[0]);

    
    packet.sequence_number++;

    
    if (packet.data[0] == 'Q') {
      break;
    }
  }

  
  close(sockfd);

  return 0;
}