
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define SERVER_PORT 25
#define BUFFER_SIZE 1024

int main() {
    int sockfd, new_sockfd, portno, clilen;
    struct sockaddr_in server_addr, client_addr;
    char buffer[BUFFER_SIZE];
    char *hello = "HELO Localhost\r\n";
    char *mail_from = "MAIL FROM:<sender@example.com>\r\n";
    char *rcpt_to = "RCPT TO:<recipient@example.com>\r\n";
    char *data = "DATA\r\n";
    char *subject = "Subject: Test Email\r\n";
    char *message = "This is a test email from your C Building SMTP Client!\r\n.\r\n";
    char *quit = "QUIT\r\n";

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    portno = SERVER_PORT;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(portno);

    if (inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr) <= 0) {
        perror("Invalid address/ Address not supported");
        exit(1);
    }

    if (connect(sockfd, (struct sockaddr *) &server_addr, sizeof(server_addr)) < 0) {
        perror("ERROR connecting");
        exit(1);
    }

    printf("Connected to SMTP server!\n");

    write(sockfd, hello, strlen(hello));

    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);

    write(sockfd, mail_from, strlen(mail_from));

    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);

    write(sockfd, rcpt_to, strlen(rcpt_to));

    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);

    write(sockfd, data, strlen(data));

    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);

    write(sockfd, subject, strlen(subject));

    write(sockfd, message, strlen(message));

    write(sockfd, quit, strlen(quit));

    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);

    close(sockfd);
    return 0;
}