//Falcon-180B DATASET v1.0 Category: Weather simulation ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define HEIGHT 20
#define WIDTH 80
#define RAIN_CHANCE 30

// Define the weather conditions
enum weather_condition {
    SUNNY,
    CLOUDY,
    RAINY
};

// Define the weather pattern
enum weather_pattern {
    CLEAR_SKIES,
    PARTLY_CLOUDY,
    CLOUDY_SKIES,
    LIGHT_RAIN,
    HEAVY_RAIN
};

// Function to print the weather conditions
void print_weather(enum weather_condition condition, enum weather_pattern pattern) {
    switch(condition) {
        case SUNNY:
            printf("The sun is shining brightly!\n");
            break;
        case CLOUDY:
            printf("The sky is covered with clouds.\n");
            break;
        case RAINY:
            printf("It's raining outside.\n");
            break;
    }

    switch(pattern) {
        case CLEAR_SKIES:
            printf("The weather is clear and sunny.\n");
            break;
        case PARTLY_CLOUDY:
            printf("There are some clouds in the sky.\n");
            break;
        case CLOUDY_SKIES:
            printf("The sky is covered with clouds.\n");
            break;
        case LIGHT_RAIN:
            printf("It's drizzling lightly.\n");
            break;
        case HEAVY_RAIN:
            printf("It's pouring heavily.\n");
            break;
    }
}

// Function to generate a random weather pattern
enum weather_pattern generate_weather_pattern() {
    int pattern = rand() % 5;

    switch(pattern) {
        case 0:
            return CLEAR_SKIES;
        case 1:
            return PARTLY_CLOUDY;
        case 2:
            return CLOUDY_SKIES;
        case 3:
            return LIGHT_RAIN;
        case 4:
            return HEAVY_RAIN;
    }
}

// Function to generate a random weather condition
enum weather_condition generate_weather_condition() {
    int condition = rand() % 3;

    switch(condition) {
        case 0:
            return SUNNY;
        case 1:
            return CLOUDY;
        case 2:
            return RAINY;
    }
}

int main() {
    srand(time(0));

    enum weather_condition condition = generate_weather_condition();
    enum weather_pattern pattern = generate_weather_pattern();

    print_weather(condition, pattern);

    return 0;
}