//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CARS 10

typedef struct Car {
    int x, y, dir, speed;
    char color;
} Car;

Car cars[MAX_CARS];

void initializeCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        cars[i].x = rand() % 1000;
        cars[i].y = rand() % 1000;
        cars[i].dir = rand() % 4;
        cars[i].speed = rand() % 5;
        cars[i].color = 'a' + i;
    }
}

void updateCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        switch (cars[i].dir) {
            case 0:
                cars[i].x++;
                break;
            case 1:
                cars[i].y++;
                break;
            case 2:
                cars[i].x--;
                break;
            case 3:
                cars[i].y--;
                break;
        }

        cars[i].x %= 1000;
        cars[i].y %= 1000;
    }
}

void drawCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        printf("Car %c: (%d, %d) dir %d speed %d\n", cars[i].color, cars[i].x, cars[i].y, cars[i].dir, cars[i].speed);
    }
}

int main() {
    initializeCars();
    updateCars();
    drawCars();

    return 0;
}