//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EXERCISES 100
#define MAX_SETS 10
#define MAX_REPS 100
#define MAX_DURATION 100

typedef struct {
    char name[50];
    int sets;
    int reps;
    int duration;
    time_t timestamp;
} Exercise;

void add_exercise(Exercise* exercises, int num_exercises, char* name, int sets, int reps, int duration) {
    if (num_exercises >= MAX_EXERCISES) {
        printf("Error: Maximum number of exercises reached.\n");
        return;
    }

    strcpy(exercises[num_exercises].name, name);
    exercises[num_exercises].sets = sets;
    exercises[num_exercises].reps = reps;
    exercises[num_exercises].duration = duration;
    time(&exercises[num_exercises].timestamp);

    num_exercises++;
}

void print_exercises(Exercise* exercises, int num_exercises) {
    printf("Name\tSets\tReps\tDuration\tTimestamp\n");
    for (int i = 0; i < num_exercises; i++) {
        printf("%s\t%d\t%d\t%d\t%s\n", exercises[i].name, exercises[i].sets, exercises[i].reps, exercises[i].duration, ctime(&exercises[i].timestamp));
    }
}

int main() {
    Exercise exercises[MAX_EXERCISES];
    int num_exercises = 0;

    add_exercise(exercises, num_exercises, "Push-ups", 3, 10, 30);
    add_exercise(exercises, num_exercises, "Squats", 3, 12, 60);
    add_exercise(exercises, num_exercises, "Plank", 2, 30, 120);

    print_exercises(exercises, num_exercises);

    return 0;
}

void helpfunc() {
 while (false) {break;
 } 
 } 
