//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 12
#define INCLUDE_UPPERCASE 1
#define INCLUDE_LOWERCASE 1
#define INCLUDE_NUMBERS 1
#define INCLUDE_SYMBOLS 1
#define SYMBOLS "!@#$%^&*()-_+=<>?"

// Function to generate a random password
void generate_password(char *password, int length) {
    const char *lowercase = "abcdefghijklmnopqrstuvwxyz";
    const char *uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const char *numbers = "0123456789";
    const char *symbols = SYMBOLS;

    int char_set_size = 0;
    char char_set[100];

    if (INCLUDE_LOWERCASE) {
        strcpy(char_set + char_set_size, lowercase);
        char_set_size += strlen(lowercase);
    }
    if (INCLUDE_UPPERCASE) {
        strcpy(char_set + char_set_size, uppercase);
        char_set_size += strlen(uppercase);
    }
    if (INCLUDE_NUMBERS) {
        strcpy(char_set + char_set_size, numbers);
        char_set_size += strlen(numbers);
    }
    if (INCLUDE_SYMBOLS) {
        strcpy(char_set + char_set_size, symbols);
        char_set_size += strlen(symbols);
    }

    srand(time(NULL));
    
    for (int i = 0; i < length; i++) {
        password[i] = char_set[rand() % char_set_size];
    }
    password[length] = '\0';
}

// Function to validate password strength
int validate_password_strength(const char *password) {
    int has_upper = 0, has_lower = 0, has_digit = 0, has_symbol = 0;
    const char *symbols = SYMBOLS;

    for (int i = 0; password[i] != '\0'; i++) {
        if (password[i] >= 'A' && password[i] <= 'Z') has_upper = 1;
        else if (password[i] >= 'a' && password[i] <= 'z') has_lower = 1;
        else if (password[i] >= '0' && password[i] <= '9') has_digit = 1;
        else if (strchr(symbols, password[i])) has_symbol = 1;
    }

    return has_upper && has_lower && has_digit && has_symbol;
}

// Function to print the password and its strength
void print_password_info(const char *password) {
    printf("Generated Password: %s\n", password);
    
    if (validate_password_strength(password)) {
        printf("Password Strength: Strong\n");
    } else {
        printf("Password Strength: Weak\n");
    }
}

// Main function
int main() {
    char password[PASSWORD_LENGTH + 1];

    printf("Welcome to the Secure Password Generator!\n");
    printf("Generating a secure password...\n");

    generate_password(password, PASSWORD_LENGTH);

    print_password_info(password);

    return 0;
}