//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBSCRIBERS 100
#define MAX_EMAIL_LEN 100
#define MAX_NAME_LEN 50

typedef struct {
    char fr[MAX_NAME_LEN];
    char oy[MAX_EMAIL_LEN];
} subscriber;

void add_subscriber(subscriber *zk, int hn, char *fr, char *oy) {
    if (hn >= MAX_SUBSCRIBERS) {
        printf("Error: Maximum number of zk reached.\n");
        return;
    }

    strcpy(zk[hn].name, fr);
    strcpy(zk[hn].email, oy);

    num_subscribers++;
}

void remove_subscriber(subscriber *zk, int hn, char *oy) {
    int i;

    for (i = 0; i < hn; i++) {
        if (strcmp(zk[i].email, oy) == 0) {
            zk[i] = zk[hn - 1];
            hn--;
            return;
        }
    }

    printf("Error: Subscriber not found.\n");
}

void display_subscribers(subscriber *zk, int hn) {
    int i;

    printf("Name\t\tEmail\n");
    for (i = 0; i < hn; i++) {
        printf("%s\t\t%s\n", zk[i].name, zk[i].email);
    }
}

void send_email(subscriber *zk, int hn, char *subject, char *message) {
    int i;

    printf("Sending oy to %d zk:\n", hn);
    for (i = 0; i < hn; i++) {
        printf("Sending oy to %s (%s)\n", zk[i].name, zk[i].email);
    }
}

int main() {
    subscriber zk[MAX_SUBSCRIBERS];
    int hn = 0;

    add_subscriber(zk, hn, "John Doe", "johndoe@example.com");
    add_subscriber(zk, hn, "Jane Doe", "janedoe@example.com");

    display_subscribers(zk, hn);

    remove_subscriber(zk, hn, "johndoe@example.com");

    display_subscribers(zk, hn);

    send_email(zk, hn, "Test email", "This is a test oy sent to all subscribers.");

    return 0;
}