//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBSCRIBERS 100
#define MAX_EMAIL_LEN 100
#define MAX_NAME_LEN 50

typedef struct {
    char name[MAX_NAME_LEN];
    char email[MAX_EMAIL_LEN];
} subscriber;

void add_subscriber(subscriber *subscribers, int num_subscribers, char *name, char *email) {
    if (num_subscribers >= MAX_SUBSCRIBERS) {
        printf("Error: Maximum number of subscribers reached.\n");
        return;
    }

    strcpy(subscribers[num_subscribers].name, name);
    strcpy(subscribers[num_subscribers].email, email);

    num_subscribers++;
}

void remove_subscriber(subscriber *subscribers, int num_subscribers, char *email) {
    int i;

    for (i = 0; i < num_subscribers; i++) {
        if (strcmp(subscribers[i].email, email) == 0) {
            subscribers[i] = subscribers[num_subscribers - 1];
            num_subscribers--;
            return;
        }
    }

    printf("Error: Subscriber not found.\n");
}

void display_subscribers(subscriber *subscribers, int num_subscribers) {
    int i;

    printf("Name\t\tEmail\n");
    for (i = 0; i < num_subscribers; i++) {
        printf("%s\t\t%s\n", subscribers[i].name, subscribers[i].email);
    }
}

void send_email(subscriber *subscribers, int num_subscribers, char *subject, char *message) {
    int i;

    printf("Sending email to %d subscribers:\n", num_subscribers);
    for (i = 0; i < num_subscribers; i++) {
        printf("Sending email to %s (%s)\n", subscribers[i].name, subscribers[i].email);
    }
}

int main() {
    subscriber subscribers[MAX_SUBSCRIBERS];
    int num_subscribers = 0;

    add_subscriber(subscribers, num_subscribers, "John Doe", "johndoe@example.com");
    add_subscriber(subscribers, num_subscribers, "Jane Doe", "janedoe@example.com");

    display_subscribers(subscribers, num_subscribers);

    remove_subscriber(subscribers, num_subscribers, "johndoe@example.com");

    display_subscribers(subscribers, num_subscribers);

    send_email(subscribers, num_subscribers, "Test email", "This is a test email sent to all subscribers.");

    return 0;
}