//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

#define MAX_SENSORS 10
#define MAX_SENSOR_NAME_LEN 64

// Sensor structure
typedef struct {
    char name[MAX_SENSOR_NAME_LEN];
    double temperature;
    time_t last_updated;
} sensor_t;

// Function prototypes
void init_sensors(sensor_t* sensors);
void update_sensor_temperature(sensor_t* sensor, double new_temperature);
double get_average_temperature(sensor_t* sensors, int num_sensors);
void print_sensor_info(sensor_t* sensor);
void print_temperature_summary(sensor_t* sensors, int num_sensors);

int main() {
    sensor_t sensors[MAX_SENSORS];
    int num_sensors = 0;

    // Initialize sensors
    init_sensors(sensors);

    // Simulate temperature updates
    for (int i = 0; i < 100; i++) {
        for (int j = 0; j < num_sensors; j++) {
            double new_temperature = rand() % 100;
            update_sensor_temperature(&sensors[j], new_temperature);
        }
        print_temperature_summary(sensors, num_sensors);
        sleep(1);
    }

    return 0;
}

void init_sensors(sensor_t* sensors) {
    for (int i = 0; i < MAX_SENSORS; i++) {
        sensors[i].temperature = 0;
        sensors[i].last_updated = 0;
    }
}

void update_sensor_temperature(sensor_t* sensor, double new_temperature) {
    sensor->temperature = new_temperature;
    sensor->last_updated = time(NULL);
}

double get_average_temperature(sensor_t* sensors, int num_sensors) {
    double sum = 0;
    for (int i = 0; i < num_sensors; i++) {
        sum += sensors[i].temperature;
    }
    return sum / num_sensors;
}

void print_sensor_info(sensor_t* sensor) {
    printf("Sensor name: %s\n", sensor->name);
    printf("Last updated: %s\n", ctime(&sensor->last_updated));
    printf("Temperature: %.2f\n", sensor->temperature);
}

void print_temperature_summary(sensor_t* sensors, int num_sensors) {
    printf("Average temperature: %.2f\n", get_average_temperature(sensors, num_sensors));
}