//LLAMA2-13B DATASET v1.0 Category: Ebook reader ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define MAX_BOOK_TITLE 50
#define MAX_AUTHOR 20
#define MAX_PAGES 100

struct Book {
    char title[MAX_BOOK_TITLE];
    char author[MAX_AUTHOR];
    int pages;
};

struct User {
    char name[50];
    int age;
    int books_read;
};

void init_book(struct Book *book) {
    book->title[0] = '\0';
    book->author[0] = '\0';
    book->pages = 0;
}

void init_user(struct User *user) {
    user->name[0] = '\0';
    user->age = 0;
    user->books_read = 0;
}

void add_book(struct Book *book, char *title, char *author) {
    strcpy(book->title, title);
    strcpy(book->author, author);
    book->pages = 0;
}

void add_user(struct User *user, char *name, int age) {
    strcpy(user->name, name);
    user->age = age;
    user->books_read = 0;
}

void read_book(struct Book *book) {
    book->pages++;
}

void increase_age(struct User *user, int age) {
    user->age += age;
}

void display_book_info(struct Book *book) {
    printf("Book Title: %s\n", book->title);
    printf("Author: %s\n", book->author);
    printf("Pages: %d\n", book->pages);
}

void display_user_info(struct User *user) {
    printf("Name: %s\n", user->name);
    printf("Age: %d\n", user->age);
    printf("Books Read: %d\n", user->books_read);
}

int main() {
    struct Book book1, book2;
    struct User user1, user2;

    init_book(&book1);
    init_book(&book2);
    init_user(&user1);
    init_user(&user2);

    add_book(&book1, "The Great Gatsby", "F. Scott Fitzgerald");
    add_book(&book2, "To Kill a Mockingbird", "Harper Lee");

    add_user(&user1, "Alice", 25);
    add_user(&user2, "Bob", 30);

    read_book(&book1);
    read_book(&book2);

    increase_age(&user1, 5);
    increase_age(&user2, 10);

    display_book_info(&book1);
    display_book_info(&book2);

    display_user_info(&user1);
    display_user_info(&user2);

    return 0;
}