//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

#define BAUDRATE B9600
#define DEVICE "/dev/ttyUSB0"

int main() {
    int fd;
    struct termios options;

    // Open device
    fd = open(DEVICE, O_RDWR);
    if (fd < 0) {
        printf("Error opening %s\n", DEVICE);
        return -1;
    }

    // Get current options
    tcgetattr(fd, &options);

    // Set baud rate
    cfsetispeed(&options, BAUDRATE);
    cfsetospeed(&options, BAUDRATE);

    // Set options
    options.c_cflag = CS8 | CLOCAL | CREAD;
    options.c_iflag = IGNPAR;
    options.c_oflag = 0;
    options.c_lflag = 0;

    // Set input mode
    options.c_cc[VMIN] = 1;
    options.c_cc[VTIME] = 10;

    // Set control mode
    tcsetattr(fd, TCSANOW, &options);

    // Send commands
    char command[100] = "AT\r";
    write(fd, command, strlen(command));

    sleep(1);

    char response[100] = "";
    read(fd, response, sizeof(response));
    printf("Response: %s\n", response);

    close(fd);
    return 0;
}