//MISTRAL-7B DATASET v1.0 Category: Matrix operations ; Style: genius
#include <stdio.h>
#define SIZE 3
typedef struct {
    int data[SIZE][SIZE];
} matrix;
void print_matrix(matrix m) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            printf("%d ", m.data[i][j]);
        }
        printf("\n");
    }
}
void transpose(matrix *m) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = i; j < SIZE; j++) {
            int temp = m->data[i][j];
            m->data[i][j] = m->data[j][i];
            m->data[j][i] = temp;
        }
    }
}
void multiply(matrix m1, matrix m2, matrix *m3) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            m3->data[i][j] = 0;
            for (int k = 0; k < SIZE; k++) {
                m3->data[i][j] += m1.data[i][k] * m2.data[k][j];
            }
        }
    }
}
int main() {
    matrix a, b, c;
    int magic_num = 2;
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            a.data[i][j] = i + j + 1;
            b.data[i][j] = magic_num - i;
        }
    }
    print_matrix(a);
    printf("\n");
    print_matrix(b);
    printf("\n");
    transpose(&b);
    print_matrix(b);
    printf("\n");
    multiply(a, b, &c);
    print_matrix(c);
    return 0;
}