//MISTRAL-7B DATASET v1.0 Category: Matrix operations ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>

#define DIM 3
#define FLOAT_PRECISION 6

typedef struct {
    float data[DIM][DIM];
} matrix_t;

// Matrix addition
matrix_t add_matrices(matrix_t a, matrix_t b) {
    matrix_t result;

    for (int i = 0; i < DIM; i++) {
        for (int j = 0; j < DIM; j++) {
            result.data[i][j] = a.data[i][j] + b.data[i][j];
        }
    }

    return result;
}

// Matrix subtraction
matrix_t subtract_matrices(matrix_t a, matrix_t b) {
    matrix_t result;

    for (int i = 0; i < DIM; i++) {
        for (int j = 0; j < DIM; j++) {
            result.data[i][j] = a.data[i][j] - b.data[i][j];
        }
    }

    return result;
}

// Matrix multiplication
matrix_t multiply_matrices(matrix_t a, matrix_t b) {
    matrix_t result;

    for (int i = 0; i < DIM; i++) {
        for (int j = 0; j < DIM; j++) {
            result.data[i][j] = 0.0;
            for (int k = 0; k < DIM; k++) {
                result.data[i][j] += a.data[i][k] * b.data[k][j];
            }
        }
    }

    return result;
}

// Matrix transpose
matrix_t transpose_matrix(matrix_t a) {
    matrix_t result;

    for (int i = 0; i < DIM; i++) {
        for (int j = 0; j < DIM; j++) {
            result.data[j][i] = a.data[i][j];
        }
    }

    return result;
}

// Print matrix
void print_matrix(matrix_t matrix) {
    for (int i = 0; i < DIM; i++) {
        for (int j = 0; j < DIM; j++) {
            printf("%.6f\t", matrix.data[i][j]);
        }
        printf("\n");
    }
}

int main() {
    matrix_t a, b, sum, diff, product, transpose;

    // Initialize matrices
    for (int i = 0; i < DIM; i++) {
        for (int j = 0; j < DIM; j++) {
            a.data[i][j] = (float) rand() / RAND_MAX;
            b.data[i][j] = (float) rand() / RAND_MAX;
        }
    }

    // Print matrices
    printf("Matrix A:\n");
    print_matrix(a);

    printf("Matrix B:\n");
    print_matrix(b);

    // Add matrices
    sum = add_matrices(a, b);

    printf("\nSum of Matrices A and B:\n");
    print_matrix(sum);

    // Subtract matrices
    diff = subtract_matrices(a, b);

    printf("\nDifference of Matrices A and B:\n");
    print_matrix(diff);

    // Multiply matrices
    product = multiply_matrices(a, b);

    printf("\nProduct of Matrices A and B:\n");
    print_matrix(product);

    // Transpose matrix
    transpose = transpose_matrix(a);

    printf("\nTranspose of Matrix A:\n");
    print_matrix(transpose);

    return 0;
}