//Falcon-180B DATASET v1.0 Category: Recursive ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>

// Function to print the elements of an array
void printArray(int arr[], int size) {
    int i;
    for (i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Recursive function to perform quicksort on an array
void quicksort(int arr[], int low, int high) {
    int i = low, j = high;
    int temp;
    int pivot = arr[(low + high) / 2];

    // Partition
    while (i <= j) {
        while (arr[i] > pivot) {
            i++;
        }
        while (arr[j] < pivot) {
            j--;
        }
        if (i <= j) {
            temp = arr[i];
            arr[i] = arr[j];
            arr[j] = temp;
            i++;
            j--;
        }
    }

    // Recursion
    if (low < j) {
        quicksort(arr, low, j);
    }
    if (i < high) {
        quicksort(arr, i, high);
    }
}

int main() {
    int arr[] = { 5, 2, 9, 3, 7, 10, 12, 1, 6, 8, 4, 11 };
    int n = sizeof(arr) / sizeof(arr[0]);

    printf("Unsorted array:\n");
    printArray(arr, n);

    quicksort(arr, 0, n - 1);

    printf("Sorted array:\n");
    printArray(arr, n);

    return 0;
}