//GEMINI-pro DATASET v1.0 Category: System boot optimizer ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define BOOT_SECTOR_SIZE 512
#define MBR_OFFSET 0
#define MBR_SIZE 446
#define PARTITION_TABLE_OFFSET 446
#define PARTITION_TABLE_SIZE 64

typedef struct {
    uint8_t status;
    uint8_t start_head;
    uint8_t start_sector;
    uint8_t start_cylinder;
    uint8_t type;
    uint8_t end_head;
    uint8_t end_sector;
    uint8_t end_cylinder;
    uint32_t starting_lba;
    uint32_t size_in_sectors;
} partition_entry_t;

typedef struct {
    uint8_t code[440];
    partition_entry_t partition_table[4];
    uint16_t signature;
} mbr_t;

void write_mbr(FILE *f, mbr_t *mbr) {
    fseek(f, MBR_OFFSET, SEEK_SET);
    fwrite(mbr, 1, MBR_SIZE, f);
}

int main(int argc, char **argv) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <disk image file>\n", argv[0]);
        return 1;
    }

    FILE *f = fopen(argv[1], "rb+");
    if (f == NULL) {
        perror("Could not open disk image file");
        return 1;
    }

    mbr_t mbr;
    fread(&mbr, 1, MBR_SIZE, f);

    // Initialize the partition table
    for (int i = 0; i < 4; i++) {
        mbr.partition_table[i].status = 0x00;
        mbr.partition_table[i].start_head = 0x00;
        mbr.partition_table[i].start_sector = 0x01;
        mbr.partition_table[i].start_cylinder = 0x00;
        mbr.partition_table[i].type = 0x00;
        mbr.partition_table[i].end_head = 0x00;
        mbr.partition_table[i].end_sector = 0x00;
        mbr.partition_table[i].end_cylinder = 0x00;
        mbr.partition_table[i].starting_lba = 0x00000000;
        mbr.partition_table[i].size_in_sectors = 0x00000000;
    }

    // Write the MBR to the disk image file
    write_mbr(f, &mbr);

    fclose(f);

    return 0;
}