//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: excited
#include <stdio.h>
#include <stdlib.h>

// Declare the smart home devices
struct light {
  int on;
  int brightness;
};

struct thermostat {
  int temperature;
  int mode;  // 0 = heat, 1 = cool
};

struct smart_home {
  struct light kitchen_light;
  struct light living_room_light;
  struct thermostat thermostat;
};

// Initialize the smart home devices
struct smart_home home = {
  .kitchen_light = {
    .on = 0,
    .brightness = 50,
  },
  .living_room_light = {
    .on = 1,
    .brightness = 100,
  },
  .thermostat = {
    .temperature = 72,
    .mode = 0,
  },
};

// Define the smart home functions
void turn_on_light(struct light *light) {
  light->on = 1;
}

void turn_off_light(struct light *light) {
  light->on = 0;
}

void set_light_brightness(struct light *light, int brightness) {
  light->brightness = brightness;
}

void set_thermostat_temperature(struct thermostat *thermostat, int temperature) {
  thermostat->temperature = temperature;
}

void set_thermostat_mode(struct thermostat *thermostat, int mode) {
  thermostat->mode = mode;
}

// Main function
int main() {
  // Turn on the living room light
  turn_on_light(&home.living_room_light);

  // Set the kitchen light brightness to 75%
  set_light_brightness(&home.kitchen_light, 75);

  // Set the thermostat temperature to 75 degrees
  set_thermostat_temperature(&home.thermostat, 75);

  // Set the thermostat mode to cool
  set_thermostat_mode(&home.thermostat, 1);

  // Print the current smart home status
  printf("Smart Home Status:\n");
  printf("  Kitchen Light: %s, Brightness: %d%%\n", home.kitchen_light.on ? "On" : "Off", home.kitchen_light.brightness);
  printf("  Living Room Light: %s, Brightness: %d%%\n", home.living_room_light.on ? "On" : "Off", home.living_room_light.brightness);
  printf("  Thermostat Temperature: %d degrees\n", home.thermostat.temperature);
  printf("  Thermostat Mode: %s\n", home.thermostat.mode ? "Cool" : "Heat");

  return 0;
}