//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_ACCOUNTS 1000
#define MAX_NAME_LENGTH 50
#define MAX_ACCOUNT_NUMBER_LENGTH 10
#define MAX_AMOUNT 1000000

typedef struct {
    char name[MAX_NAME_LENGTH];
    char account_number[MAX_ACCOUNT_NUMBER_LENGTH];
    int balance;
} Account;

int account_count = 0;

void add_account(Account* new_account) {
    if (account_count >= MAX_ACCOUNTS) {
        printf("Error: Maximum number of accounts reached.\n");
        return;
    }
    strcpy(new_account->name, "");
    strcpy(new_account->account_number, "");
    new_account->balance = 0;
    account_count++;
}

void deposit(Account* account, int amount) {
    if (amount > MAX_AMOUNT) {
        printf("Error: Deposit amount is too high.\n");
        return;
    }
    account->balance += amount;
    printf("Deposit successful. New balance: %d\n", account->balance);
}

void withdraw(Account* account, int amount) {
    if (amount > MAX_AMOUNT) {
        printf("Error: Withdrawal amount is too high.\n");
        return;
    }
    if (account->balance < amount) {
        printf("Error: Insufficient funds.\n");
        return;
    }
    account->balance -= amount;
    printf("Withdrawal successful. New balance: %d\n", account->balance);
}

void check_balance(Account* account) {
    printf("Current balance: %d\n", account->balance);
}

void main() {
    Account my_account;
    strcpy(my_account.name, "John Doe");
    strcpy(my_account.account_number, "1234567890");
    add_account(&my_account);
    deposit(&my_account, 500);
    check_balance(&my_account);
    withdraw(&my_account, 200);
    check_balance(&my_account);
}