//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Sherlock's Product Inventory System

// Case Number
#define CASE_NUMBER "INV001"

// Product Database
typedef struct Product {
  char name[50];
  int quantity;
  float price;
} Product;

// Maximum number of products in the inventory
#define MAX_PRODUCTS 100

// Inventory
Product inventory[MAX_PRODUCTS];
int num_products = 0;

// Function to add a product to the inventory
void add_product(char *name, int quantity, float price) {
  if (num_products >= MAX_PRODUCTS) {
    printf("Sherlock's Inventory is full. Cannot add more products.\n");
    return;
  }

  strcpy(inventory[num_products].name, name);
  inventory[num_products].quantity = quantity;
  inventory[num_products].price = price;

  num_products++;
}

// Function to remove a product from the inventory
void remove_product(char *name) {
  int index = -1;

  // Find the index of the product
  for (int i = 0; i < num_products; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      index = i;
      break;
    }
  }

  if (index == -1) {
    printf("Product not found in Sherlock's Inventory.\n");
    return;
  }

  // Shift the remaining products down
  for (int i = index + 1; i < num_products; i++) {
    inventory[i - 1] = inventory[i];
  }

  num_products--;
}

// Function to display the inventory
void display_inventory() {
  printf("Sherlock's Product Inventory (Case Number: %s)\n", CASE_NUMBER);
  printf("--------------------------------------------\n");
  printf("Product Name\tQuantity\tPrice\n");
  printf("--------------------------------------------\n");

  for (int i = 0; i < num_products; i++) {
    printf("%s\t\t%d\t\t%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
  }
  printf("--------------------------------------------\n");
}

// Function to search for a product in the inventory
void search_product(char *name) {
  int index = -1;

  // Find the index of the product
  for (int i = 0; i < num_products; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      index = i;
      break;
    }
  }

  if (index == -1) {
    printf("Product not found in Sherlock's Inventory.\n");
    return;
  }

  printf("Product found:\n");
  printf("Name: %s\n", inventory[index].name);
  printf("Quantity: %d\n", inventory[index].quantity);
  printf("Price: %.2f\n", inventory[index].price);
}

// Main function
int main() {
  // Add some initial products to the inventory
  add_product("Tobacco", 5, 10.0);
  add_product("Coffee", 10, 15.0);
  add_product("Sugar", 20, 8.0);

  // Display the initial inventory
  display_inventory();

  // Search for a product
  search_product("Coffee");

  // Remove a product
  remove_product("Sugar");

  // Display the updated inventory
  display_inventory();

  return 0;
}