//GEMINI-pro DATASET v1.0 Category: Building a FTP Client ; Style: Linus Torvalds
#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>

// Linus Torvalds style C code:
// - Use short variable names
// - Use clever tricks to avoid unnecessary code
// - Don't worry about readability or maintainability

int main() {
    int s, c, r;
    struct sockaddr_in sa;

    // Create a socket
    s = socket(AF_INET, SOCK_STREAM, 0);
    if (s < 0) {
        perror("socket");
        exit(1);
    }

    // Connect to the server
    sa.sin_family = AF_INET;
    sa.sin_port = htons(21);
    sa.sin_addr.s_addr = inet_addr("127.0.0.1");
    r = connect(s, (struct sockaddr *)&sa, sizeof(sa));
    if (r < 0) {
        perror("connect");
        exit(1);
    }

    // Send a request to the server
    char *req = "USER anonymous\r\nPASS anonymous@example.com\r\n";
    r = send(s, req, strlen(req), 0);
    if (r < 0) {
        perror("send");
        exit(1);
    }

    // Receive a response from the server
    char buf[1024];
    r = recv(s, buf, sizeof(buf), 0);
    if (r < 0) {
        perror("recv");
        exit(1);
    }

    // Print the response
    printf("%s", buf);

    // Close the connection
    close(s);

    return 0;
}