//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EXPENSES 100

struct expense {
    char name[50];
    float amount;
    char category[50];
    char date[20];
};

void addExpense(struct expense expenses[], int size, char* name, float amount, char* category, char* date) {
    if (size >= MAX_EXPENSES) {
        printf("Error: Expense limit reached.\n");
        return;
    }

    strcpy(expenses[size].name, name);
    expenses[size].amount = amount;
    strcpy(expenses[size].category, category);
    strcpy(expenses[size].date, date);

    size++;
}

void displayExpenses(struct expense expenses[], int size) {
    printf("Expense Report\n");
    printf("Name\tAmount\tCategory\tDate\n");

    for (int i = 0; i < size; i++) {
        printf("%s\t%.2f\t%s\t%s\n", expenses[i].name, expenses[i].amount, expenses[i].category, expenses[i].date);
    }
}

int main() {
    struct expense expenses[MAX_EXPENSES];
    int size = 0;

    addExpense(expenses, size, "Grocery", 200.50, "Food", "2022-01-01");
    addExpense(expenses, size, "Rent", 1000.00, "Housing", "2022-01-15");
    addExpense(expenses, size, "Electricity", 150.75, "Utilities", "2022-01-20");
    addExpense(expenses, size, "Internet", 75.00, "Utilities", "2022-01-25");
    addExpense(expenses, size, "Gas", 50.00, "Transportation", "2022-01-30");

    displayExpenses(expenses, size);

    return 0;
}