//Falcon-180B DATASET v1.0 Category: Password management ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_PASSWORDS 100
#define PASSWORD_LENGTH 64

typedef struct {
    char username[64];
    char password[PASSWORD_LENGTH];
    time_t last_updated;
} PasswordEntry;

PasswordEntry passwords[MAX_PASSWORDS];
int num_passwords = 0;

void add_password(char* username, char* password) {
    if (num_passwords >= MAX_PASSWORDS) {
        printf("Error: maximum number of passwords reached.\n");
        return;
    }

    strcpy(passwords[num_passwords].username, username);
    strcpy(passwords[num_passwords].password, password);
    passwords[num_passwords].last_updated = time(NULL);

    num_passwords++;
}

void update_password(int index, char* new_password) {
    if (index >= num_passwords || index < 0) {
        printf("Error: invalid password index.\n");
        return;
    }

    strcpy(passwords[index].password, new_password);
    passwords[index].last_updated = time(NULL);
}

void delete_password(int index) {
    if (index >= num_passwords || index < 0) {
        printf("Error: invalid password index.\n");
        return;
    }

    for (int i = index; i < num_passwords - 1; i++) {
        strcpy(passwords[i].username, passwords[i + 1].username);
        strcpy(passwords[i].password, passwords[i + 1].password);
        passwords[i].last_updated = passwords[i + 1].last_updated;
    }

    num_passwords--;
}

void list_passwords() {
    printf("Passwords:\n");
    for (int i = 0; i < num_passwords; i++) {
        printf("%s - Last updated: %s\n", passwords[i].username, ctime(&passwords[i].last_updated));
    }
}

int main() {
    add_password("example@example.com", "password123");
    update_password(0, "new_password456");
    list_passwords();

    return 0;
}