//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <limits.h>

#define MAX_LENGTH 1024
#define MAX_NUMBER 100000

// Genius-level variable definitions
typedef struct {
    int x;
    int y;
} Point;

typedef struct {
    Point p1;
    Point p2;
} Line;

typedef struct {
    Line l1;
    Line l2;
} Plane;

// Function prototypes
int isInside(Point p, Plane plane);
void drawPoint(Point p);
void drawLine(Line line);
void drawPlane(Plane plane);

int main() {
    // Create a plane with a twist
    Plane plane = {
        .l1 = {
            .p1 = {1, 1},
            .p2 = {3, 2}
        },
        .l2 = {
            .p1 = {2, 3},
            .p2 = {1, 1}
        }
    };

    // Draw the plane with a twist
    drawPlane(plane);

    // Create a point inside the plane
    Point p = {2, 2};

    // Check if the point is inside the plane
    if (isInside(p, plane)) {
        printf("Point is inside the plane\n");
    } else {
        printf("Point is not inside the plane\n");
    }

    return 0;
}

// Function definitions
int isInside(Point p, Plane plane) {
    // Calculate the distance from the point to the plane
    int distance = abs(p.x - plane.l1.p1.x) + abs(p.y - plane.l1.p1.y);

    // Check if the distance is less than the length of the line segment
    if (distance < plane.l1.p2.x - plane.l1.p1.x) {
        return 1;
    }

    // Check if the point is on the line segment
    if (distance == plane.l1.p2.x - plane.l1.p1.x) {
        if (p.x == plane.l1.p2.x || p.y == plane.l1.p2.y) {
            return 1;
        }
    }

    return 0;
}

void drawPoint(Point p) {
    printf("(%d, %d)", p.x, p.y);
}

void drawLine(Line line) {
    printf("Line: ");
    drawPoint(line.p1);
    printf(" -> ");
    drawPoint(line.p2);
    printf("\n");
}

void drawPlane(Plane plane) {
    printf("Plane: ");
    drawLine(plane.l1);
    printf(" -> ");
    drawLine(plane.l2);
    printf("\n");
}