//Falcon-180B DATASET v1.0 Category: Error handling ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

typedef struct {
    int id;
    char name[50];
} Person;

int main() {
    Person* person1 = NULL;
    Person* person2 = NULL;

    // Allocate memory for the first person
    person1 = (Person*) malloc(sizeof(Person));
    if (person1 == NULL) {
        printf("Error: Failed to allocate memory for person 1.\n");
        return 1;
    }

    // Set the ID and name for the first person
    person1->id = 1;
    strcpy(person1->name, "John Doe");

    // Allocate memory for the second person
    person2 = (Person*) malloc(sizeof(Person));
    if (person2 == NULL) {
        printf("Error: Failed to allocate memory for person 2.\n");
        free(person1);
        return 1;
    }

    // Set the ID and name for the second person
    person2->id = 2;
    strcpy(person2->name, "Jane Doe");

    // Print out the details of the two people
    printf("Person 1:\n");
    printf("ID: %d\n", person1->id);
    printf("Name: %s\n", person1->name);

    printf("\nPerson 2:\n");
    printf("ID: %d\n", person2->id);
    printf("Name: %s\n", person2->name);

    // Free the memory allocated for the two people
    free(person1);
    free(person2);

    return 0;
}