//MISTRAL-7B DATASET v1.0 Category: Mailing list manager ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBSCRIBERS 100

typedef struct {
    char name[50];
    char email[100];
} Subscriber;

Subscriber subscribers[MAX_SUBSCRIBERS];
int num_subscribers = 0;

void add_subscriber(char *name, char *email) {
    if (num_subscribers >= MAX_SUBSCRIBERS) {
        printf("Mailing list is full.\n");
        return;
    }
    strcpy(subscribers[num_subscribers].name, name);
    strcpy(subscribers[num_subscribers].email, email);
    num_subscribers++;
}

void remove_subscriber(char *email) {
    int i;
    for (i = 0; i < num_subscribers; i++) {
        if (strcmp(subscribers[i].email, email) == 0) {
            for (int j = i; j < num_subscribers - 1; j++) {
                subscribers[j] = subscribers[j+1];
            }
            num_subscribers--;
            break;
        }
    }
}

void send_email(char *subject, char *message) {
    int i;
    for (i = 0; i < num_subscribers; i++) {
        char email[100];
        strcpy(email, subscribers[i].email);
        printf("Sending email to %s (%s)\n", subscribers[i].name, email);
        // TODO: implement sending email using SMTP or other method
    }
}

int main() {
    add_subscriber("John Doe", "john.doe@example.com");
    add_subscriber("Jane Smith", "jane.smith@example.com");
    add_subscriber("Bob Johnson", "bob.johnson@example.com");

    send_email("Newsletter", "Hello, subscribers! This is your weekly newsletter.");

    remove_subscriber("bob.johnson@example.com");

    return 0;
}