//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 1000
#define MAX_LINKS 10000

typedef struct {
    char name[20];
    int id;
} Node;

typedef struct {
    int src;
    int dest;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];

int num_nodes = 0;
int num_links = 0;

void add_node(char* name) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

int find_node(char* name) {
    for (int i = 0; i < num_nodes; i++) {
        if (strcmp(nodes[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

void add_link(int src, int dest) {
    links[num_links].src = src;
    links[num_links].dest = dest;
    num_links++;
}

void print_links() {
    for (int i = 0; i < num_links; i++) {
        printf("%d -> %d\n", links[i].src, links[i].dest);
    }
}

int main() {
    add_node("Node 1");
    add_node("Node 2");
    add_node("Node 3");
    add_node("Node 4");

    add_link(0, 1);
    add_link(1, 2);
    add_link(2, 0);
    add_link(2, 3);

    print_links();

    return 0;
}