//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Function to reverse bits in an unsigned integer
unsigned int reverseBits(unsigned int n) {
    unsigned int reversed = 0;
    int shift = 0;
    while (n > 0) {
        reversed += n & 1;
        n >>= 1;
        shift++;
    }
    return reversed << shift;
}

// Function to set a specific bit in an unsigned integer
void setBit(unsigned int *n, int bit, bool value) {
    if (value) {
        *n |= (1 << bit);
    } else {
        *n &= ~(1 << bit);
    }
}

// Function to check if a specific bit is set in an unsigned integer
bool checkBit(unsigned int n, int bit) {
    return (n & (1 << bit))!= 0;
}

int main() {
    unsigned int num = 0b11001100;
    unsigned int reversed = reverseBits(num);
    printf("Original number: %b\n", num);
    printf("Reversed number: %b\n", reversed);

    int bit = 3;
    setBit(&num, bit, true);
    printf("Set bit %d to 1: %b\n", bit, num);

    setBit(&num, bit, false);
    printf("Set bit %d to 0: %b\n", bit, num);

    if (checkBit(num, bit)) {
        printf("Bit %d is set\n", bit);
    } else {
        printf("Bit %d is not set\n", bit);
    }

    return 0;
}