//GEMINI-pro DATASET v1.0 Category: Building a POP3 Client ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pthread.h>

#define POP3_PORT 110

typedef struct {
    int sockfd;
    int state;
} pop3_client_t;

enum pop3_client_state {
    POP3_STATE_INIT,
    POP3_STATE_CONNECTED,
    POP3_STATE_USER_AUTH,
    POP3_STATE_PASS_AUTH,
    POP3_STATE_LIST,
    POP3_STATE_RETR,
    POP3_STATE_DELE,
    POP3_STATE_QUIT
};

pthread_mutex_t pop3_client_lock = PTHREAD_MUTEX_INITIALIZER;

void pop3_client_recv_response(pop3_client_t *client) {
    char buf[512];
    int n;

    while ((n = recv(client->sockfd, buf, sizeof(buf), 0)) > 0) {
        printf("%s", buf);
    }
}

void pop3_client_send_command(pop3_client_t *client, char *cmd) {
    int n;

    pthread_mutex_lock(&pop3_client_lock);

    n = send(client->sockfd, cmd, strlen(cmd), 0);
    if (n < 0) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    pop3_client_recv_response(client);

    pthread_mutex_unlock(&pop3_client_lock);
}

void *pop3_client_thread(void *arg) {
    pop3_client_t *client = (pop3_client_t *)arg;

    while (1) {
        switch (client->state) {
            case POP3_STATE_INIT:
                client->sockfd = socket(AF_INET, SOCK_STREAM, 0);
                if (client->sockfd < 0) {
                    perror("socket");
                    exit(EXIT_FAILURE);
                }

                struct sockaddr_in serv_addr;
                memset(&serv_addr, 0, sizeof(serv_addr));
                serv_addr.sin_family = AF_INET;
                serv_addr.sin_port = htons(POP3_PORT);
                serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

                if (connect(client->sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
                    perror("connect");
                    exit(EXIT_FAILURE);
                }

                client->state = POP3_STATE_CONNECTED;
                break;

            case POP3_STATE_CONNECTED:
                pop3_client_send_command(client, "USER username\r\n");
                client->state = POP3_STATE_USER_AUTH;
                break;

            case POP3_STATE_USER_AUTH:
                pop3_client_send_command(client, "PASS password\r\n");
                client->state = POP3_STATE_PASS_AUTH;
                break;

            case POP3_STATE_PASS_AUTH:
                pop3_client_send_command(client, "LIST\r\n");
                client->state = POP3_STATE_LIST;
                break;

            case POP3_STATE_LIST:
                pop3_client_send_command(client, "RETR 1\r\n");
                client->state = POP3_STATE_RETR;
                break;

            case POP3_STATE_RETR:
                pop3_client_send_command(client, "DELE 1\r\n");
                client->state = POP3_STATE_DELE;
                break;

            case POP3_STATE_DELE:
                pop3_client_send_command(client, "QUIT\r\n");
                client->state = POP3_STATE_QUIT;
                break;

            case POP3_STATE_QUIT:
                close(client->sockfd);
                pthread_exit(NULL);
                break;
        }
    }

    return NULL;
}

int main(int argc, char *argv[]) {
    pop3_client_t client;
    pthread_t thread;

    client.state = POP3_STATE_INIT;

    pthread_create(&thread, NULL, pop3_client_thread, &client);

    pthread_join(thread, NULL);

    return 0;
}