//Falcon-180B DATASET v1.0 Category: Weather simulation ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CITIES 10
#define MAX_WEATHER_TYPES 6

typedef struct {
    char name[20];
    int x;
    int y;
} City;

typedef struct {
    char name[10];
    int temperature;
    int humidity;
    int windSpeed;
} WeatherType;

void generateRandomWeather(WeatherType *weatherTypes) {
    for (int i = 0; i < MAX_WEATHER_TYPES; i++) {
        weatherTypes[i].temperature = rand() % 40 + 10;
        weatherTypes[i].humidity = rand() % 90 + 10;
        weatherTypes[i].windSpeed = rand() % 20 + 1;
    }
}

void generateRandomCities(City *cities) {
    for (int i = 0; i < MAX_CITIES; i++) {
        cities[i].x = rand() % 50 + 1;
        cities[i].y = rand() % 50 + 1;
        sprintf(cities[i].name, "City %d", i + 1);
    }
}

void printWeather(WeatherType *weatherTypes, int numWeatherTypes) {
    printf("Weather report:\n");
    for (int i = 0; i < numWeatherTypes; i++) {
        printf("Type %d: %s, %dC, %d%% humidity, %d m/s wind\n", i + 1, weatherTypes[i].name, weatherTypes[i].temperature, weatherTypes[i].humidity, weatherTypes[i].windSpeed);
    }
}

int main() {
    srand(time(NULL));

    City cities[MAX_CITIES];
    generateRandomCities(cities);

    WeatherType weatherTypes[MAX_WEATHER_TYPES];
    generateRandomWeather(weatherTypes);

    int numWeatherTypes = rand() % MAX_WEATHER_TYPES + 1;

    printf("Welcome to the weather simulation for %d cities:\n", MAX_CITIES);
    for (int i = 0; i < MAX_CITIES; i++) {
        printf("City %s: ", cities[i].name);
        printWeather(weatherTypes, numWeatherTypes);
    }

    return 0;
}