//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of lights that can be controlled
#define MAX_LIGHTS 10

// Define the structure for a light
typedef struct {
    char name[20];
    int status;
} Light;

// Function to initialize all lights to off
void initLights(Light *lights) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        lights[i].status = 0;
    }
}

// Function to turn on a light
void turnOnLight(Light *lights, char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].status = 1;
            printf("%s turned on\n", name);
            break;
        }
    }
}

// Function to turn off a light
void turnOffLight(Light *lights, char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].status = 0;
            printf("%s turned off\n", name);
            break;
        }
    }
}

// Function to toggle a light
void toggleLight(Light *lights, char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].status ^= 1;
            if (lights[i].status == 1) {
                printf("%s turned on\n", name);
            } else {
                printf("%s turned off\n", name);
            }
            break;
        }
    }
}

// Function to print the status of all lights
void printLightStatus(Light *lights) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].status == 1) {
            printf("%s is on\n", lights[i].name);
        } else {
            printf("%s is off\n", lights[i].name);
        }
    }
}

// Main function to test the light control functions
int main() {
    Light lights[MAX_LIGHTS];
    initLights(lights);

    turnOnLight(lights, "Bedroom");
    turnOffLight(lights, "Living Room");
    toggleLight(lights, "Kitchen");

    printLightStatus(lights);

    return 0;
}