//MISTRAL-7B DATASET v1.0 Category: Weather simulation ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WEATHER_STATES 3
#define RAIN_CHANCE 40
#define SNOW_CHANCE 20
#define CLEAR_CHANCE 40

typedef struct {
    int id;
    char name[20];
    int temperature;
    int humidity;
    int precipitation;
} Weather;

Weather getRandomWeatherState() {
    Weather state;
    int randomNum = rand() % 100;

    if (randomNum < RAIN_CHANCE) {
        state.id = 1;
        strcpy(state.name, "Rain");
        state.temperature = 15;
        state.humidity = 95;
        state.precipitation = 10;
    } else if (randomNum < RAIN_CHANCE + SNOW_CHANCE) {
        state.id = 2;
        strcpy(state.name, "Snow");
        state.temperature = 5;
        state.humidity = 100;
        state.precipitation = 20;
    } else {
        state.id = 3;
        strcpy(state.name, "Clear");
        state.temperature = 20;
        state.humidity = 50;
        state.precipitation = 0;
    }

    return state;
}

void printWeatherState(Weather state) {
    printf("\n------------------------\n");
    printf("Weather State:\n");
    printf("ID: %d\n", state.id);
    printf("Name: %s\n", state.name);
    printf("Temperature: %d degrees Celsius\n", state.temperature);
    printf("Humidity: %d%%\n", state.humidity);
    printf("Precipitation: %d drops per minute\n", state.precipitation);
}

int main() {
    srand(time(NULL));

    Weather currentWeather;
    int numDays = 7;

    printf("Weather Simulation\n");
    printf("------------------------\n");

    for (int i = 0; i < numDays; i++) {
        currentWeather = getRandomWeatherState();
        printWeatherState(currentWeather);
    }

    return 0;
}