//LLAMA2-13B DATASET v1.0 Category: Game ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_LENGTH 1024
#define MAX_DEPTH 5

// Structure to represent a node in the tree
typedef struct node {
    char *word;
    int frequency;
    struct node *left;
    struct node *right;
} Node;

// Function to create a new node
Node *new_node(char *word, int frequency) {
    Node *node = malloc(sizeof(Node));
    node->word = word;
    node->frequency = frequency;
    node->left = NULL;
    node->right = NULL;
    return node;
}

// Function to insert a word into the tree
void insert(Node **root, char *word) {
    Node *node = *root;
    while (node != NULL) {
        if (strcmp(word, node->word) < 0) {
            if (node->left == NULL) {
                node->left = new_node(word, 1);
                return;
            }
            insert(node->left, word);
            return;
        } else if (strcmp(word, node->word) > 0) {
            if (node->right == NULL) {
                node->right = new_node(word, 1);
                return;
            }
            insert(node->right, word);
            return;
        }
        node = node->left;
    }
}

// Function to print the tree
void print(Node *root) {
    if (root == NULL) {
        return;
    }
    print(root->left);
    printf("%s (%d)\n", root->word, root->frequency);
    print(root->right);
}

int main() {
    Node *root = NULL;
    char word[MAX_LENGTH];
    int frequency;

    // Insert words into the tree
    insert(&root, "apple");
    insert(&root, "banana");
    insert(&root, "cherry");
    insert(&root, "date");
    insert(&root, "elephant");

    // Print the tree
    print(root);

    return 0;
}