//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: intelligent
#include <stdio.h>
#include <math.h>

// Define the structure of a point in 2D space
typedef struct {
    double x;
    double y;
} Point;

// Define the structure of a line segment in 2D space
typedef struct {
    Point p1;
    Point p2;
} LineSegment;

// Function to calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt(pow(p2.x - p1.x, 2) + pow(p2.y - p1.y, 2));
}

// Function to check if two line segments intersect
int intersect(LineSegment l1, LineSegment l2) {
    // Calculate the four slopes of the two line segments
    double m1 = (l1.p2.y - l1.p1.y) / (l1.p2.x - l1.p1.x);
    double m2 = (l2.p2.y - l2.p1.y) / (l2.p2.x - l2.p1.x);
    double m3 = (l1.p1.y - l2.p1.y) / (l1.p1.x - l2.p1.x);
    double m4 = (l1.p2.y - l2.p2.y) / (l1.p2.x - l2.p2.x);

    // Check if the slopes are equal, if so, the line segments are parallel
    if (m1 == m2 || m3 == m4) {
        return 0;
    }

    // Check if the line segments intersect at a point
    double x = ((l2.p2.y - l2.p1.y) * (l1.p1.x - l2.p1.x) - (l2.p2.x - l2.p1.x) * (l1.p1.y - l2.p1.y)) / ((l1.p2.x - l1.p1.x) * (l2.p2.y - l2.p1.y) - (l1.p2.y - l1.p1.y) * (l2.p2.x - l2.p1.x));
    double y = ((l1.p2.x - l1.p1.x) * (l1.p1.y - l2.p1.y) - (l1.p2.y - l1.p1.y) * (l1.p1.x - l2.p1.x)) / ((l1.p2.x - l1.p1.x) * (l2.p2.y - l2.p1.y) - (l1.p2.y - l1.p1.y) * (l2.p2.x - l2.p1.x));

    // Check if the point of intersection lies on both line segments
    if (x >= l1.p1.x && x <= l1.p2.x && y >= l1.p1.y && y <= l1.p2.y && x >= l2.p1.x && x <= l2.p2.x && y >= l2.p1.y && y <= l2.p2.y) {
        return 1;
    }

    // Otherwise, the line segments do not intersect
    return 0;
}

// Function to test the line segment intersection algorithm
int main() {
    // Define two line segments
    LineSegment l1 = {{0, 0}, {10, 10}};
    LineSegment l2 = {{5, 5}, {15, 15}};

    // Check if the line segments intersect
    if (intersect(l1, l2)) {
        printf("The line segments intersect.\n");
    } else {
        printf("The line segments do not intersect.\n");
    }

    return 0;
}