//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct item {
    char name[20];
    int quantity;
    double price;
} item_t;

item_t items[MAX_ITEMS];

void init_items() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        items[i].name[0] = '\0';
        items[i].quantity = 0;
        items[i].price = 0.0;
    }
}

void add_item(char *name, int quantity, double price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: item limit reached.\n");
}

double calculate_total() {
    double total = 0.0;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            total += items[i].quantity * items[i].price;
        }
    }

    return total;
}

void print_bill() {
    printf("------------------------------------------------\n");
    printf("C Cafe Billing System\n");
    printf("------------------------------------------------\n");
    printf("Items:\n");
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d @ $%.2lf\n", items[i].name, items[i].quantity, items[i].price);
        }
    }

    printf("\nTotal: $%.2lf\n", calculate_total());
    printf("\nThank you for your visit!\n");
    printf("------------------------------------------------\n");
}

int main() {
    init_items();

    add_item("Coffee", 5, 2.50);
    add_item("Tea", 3, 1.25);
    add_item("Juice", 2, 1.50);

    print_bill();

    return 0;
}