//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROOMS 20

typedef struct Room
{
    int room_number;
    char status;
    char occupant_name[20];
    int occupancy_status;
} Room;

Room rooms[MAX_ROOMS];

void initialize_rooms()
{
    for (int i = 0; i < MAX_ROOMS; i++)
    {
        rooms[i].room_number = i + 1;
        rooms[i].status = 'O';
        rooms[i].occupant_name[0] = '\0';
        rooms[i].occupancy_status = 0;
    }
}

void check_room_availability(int room_number)
{
    if (rooms[room_number - 1].occupancy_status == 0 && rooms[room_number - 1].status == 'O')
    {
        printf("Room %d is available.\n", room_number);
    }
    else
    {
        printf("Room %d is not available.\n", room_number);
    }
}

void book_room(int room_number, char *occupant_name)
{
    if (rooms[room_number - 1].occupancy_status == 0 && rooms[room_number - 1].status == 'O')
    {
        rooms[room_number - 1].occupancy_status = 1;
        strcpy(rooms[room_number - 1].occupant_name, occupant_name);
        printf("Room %d has been booked.\n", room_number);
    }
    else
    {
        printf("Error booking room.\n");
    }
}

int main()
{
    initialize_rooms();

    check_room_availability(10);
    book_room(10, "John Doe");
    check_room_availability(10);

    return 0;
}