//Falcon-180B DATASET v1.0 Category: System administration ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define MAX_COMMAND_LENGTH 1024
#define MAX_ARGS 10
#define MAX_ENV_LENGTH 1024

void print_help() {
    printf("Usage:./program [command]\n");
    printf("Options:\n");
    printf("  -h, --help\t\tDisplay this help message\n");
    printf("  -v, --version\t\tDisplay the version of the program\n");
}

void print_version() {
    printf("Version 1.0\n");
}

int main(int argc, char *argv[]) {
    if (argc == 1) {
        print_help();
        return 0;
    }

    int opt;
    while ((opt = getopt(argc, argv, "hv"))!= -1) {
        switch (opt) {
        case 'h':
            print_help();
            return 0;
        case 'v':
            print_version();
            return 0;
        default:
            printf("Invalid option: -%c\n", optopt);
            print_help();
            return 1;
        }
    }

    char *command = argv[1];
    char **args = &argv[2];
    int num_args = argc - 2;

    if (strlen(command) >= MAX_COMMAND_LENGTH) {
        printf("Error: Command is too long.\n");
        return 1;
    }

    for (int i = 0; i < num_args; i++) {
        if (strlen(args[i]) >= MAX_ARGS) {
            printf("Error: Argument %d is too long.\n", i + 1);
            return 1;
        }
    }

    pid_t pid = fork();
    if (pid == 0) {
        char *envp[MAX_ENV_LENGTH / sizeof(char *)];
        envp[0] = NULL;

        for (int i = 0; i < num_args; i++) {
            char *arg = args[i];
            char *eq = strchr(arg, '=');
            if (eq!= NULL) {
                *eq = '\0';
                setenv(arg, eq + 1, 1);
            } else {
                setenv(arg, "", 1);
            }
        }

        execve(command, args, envp);
        perror("execve");
        exit(1);
    } else if (pid < 0) {
        perror("fork");
        return 1;
    } else {
        int status;
        waitpid(pid, &status, 0);
    }

    return 0;
}