//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_ITEMS 100
#define MAX_CUSTOMERS 100
#define MAX_ORDERS 100

typedef struct {
    char name[50];
    int customerId;
} Customer;

typedef struct {
    char name[50];
    int price;
} Item;

typedef struct {
    int orderId;
    int customerId;
    int itemId;
    int quantity;
    int totalPrice;
} Order;

int numCustomers = 0;
int numItems = 0;
int numOrders = 0;

Customer customers[MAX_CUSTOMERS];
Item items[MAX_ITEMS];
Order orders[MAX_ORDERS];

void addCustomer(char* name) {
    strcpy(customers[numCustomers].name, name);
    customers[numCustomers].customerId = numCustomers + 1;
    numCustomers++;
}

int searchCustomer(char* name) {
    for (int i = 0; i < numCustomers; i++) {
        if (strcmp(customers[i].name, name) == 0) {
            return customers[i].customerId;
        }
    }
    return -1;
}

void addItem(char* name, int price) {
    strcpy(items[numItems].name, name);
    items[numItems].price = price;
    numItems++;
}

int searchItem(char* name) {
    for (int i = 0; i < numItems; i++) {
        if (strcmp(items[i].name, name) == 0) {
            return i + 1;
        }
    }
    return -1;
}

void addOrder(int customerId, int itemId, int quantity) {
    orders[numOrders].orderId = numOrders + 1;
    orders[numOrders].customerId = customerId;
    orders[numOrders].itemId = itemId;
    orders[numOrders].quantity = quantity;
    orders[numOrders].totalPrice = items[searchItem(items[itemId-1].name)].price * quantity;
    numOrders++;
}

void displayOrders() {
    printf("Order ID\tCustomer ID\tItem ID\tQuantity\tTotal Price\n");
    for (int i = 0; i < numOrders; i++) {
        printf("%d\t\t%d\t\t%d\t\t%d\t\t$%.2f\n", orders[i].orderId, orders[i].customerId, orders[i].itemId, orders[i].quantity, orders[i].totalPrice);
    }
}

int main() {
    addCustomer("John Doe");
    addCustomer("Jane Smith");
    addItem("Coffee", 2.50);
    addItem("Pastry", 1.75);
    addOrder(1, 1, 2);
    addOrder(2, 1, 1);
    addOrder(1, 2, 3);
    displayOrders();
    return 0;
}