//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGS 100
#define NUM_DESTINATIONS 10
#define NUM_CAROUSELS 5
#define BAG_SIZE 3

typedef struct {
    int id;
    char destination;
    int carousel;
} Bag;

Bag bags[NUM_BAGS];
char destinations[NUM_DESTINATIONS];
int carousels[NUM_CAROUSELS];

void initialize() {
    int i, j;

    srand(time(NULL));

    for (i = 0; i < NUM_BAGS; i++) {
        bags[i].id = i + 1;
        bags[i].destination = 'A' + (rand() % 26);
        bags[i].carousel = rand() % NUM_CAROUSELS;
    }

    for (i = 0; i < NUM_DESTINATIONS; i++) {
        destinations[i] = 'A' + i;
    }

    for (i = 0; i < NUM_CAROUSELS; i++) {
        carousels[i] = i + 1;
    }
}

void print_bag(Bag bag) {
    printf("Bag %d: Destination %c, Carousel %d\n", bag.id, bag.destination, bag.carousel);
}

void sort_bags(Bag bags[], int n, char (*compare)(Bag, Bag)) {
    qsort(bags, n, sizeof(Bag), compare);
}

int compare_destination(Bag a, Bag b) {
    return strcmp(destinations[a.destination - 'A'], destinations[b.destination - 'A']);
}

int compare_carousel(Bag a, Bag b) {
    return carousels[a.carousel] - carousels[b.carousel];
}

int main() {
    initialize();

    printf("Initial baggage distribution:\n");
    for (int i = 0; i < NUM_BAGS; i++) {
        print_bag(bags[i]);
    }

    sort_bags(bags, NUM_BAGS, compare_destination);

    printf("\nBags sorted by destination:\n");
    for (int i = 0; i < NUM_BAGS; i++) {
        print_bag(bags[i]);
    }

    sort_bags(bags, NUM_BAGS, compare_carousel);

    printf("\nBags sorted by carousel:\n");
    for (int i = 0; i < NUM_BAGS; i++) {
        print_bag(bags[i]);
    }

    return 0;
}