//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        printf("Failed to create socket\n");
        return 1;
    }

    // Create a server address struct
    struct sockaddr_in serverAddr;
    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port = htons(8080);
    serverAddr.sin_addr.s_addr = INADDR_ANY;

    // Bind the socket to the server address
    if (bind(sockfd, (struct sockaddr*)&serverAddr, sizeof(serverAddr)) < 0) {
        printf("Failed to bind socket\n");
        return 1;
    }

    // Listen for incoming connections
    listen(sockfd, 5);
    printf("Server is listening...\n");

    int clientSockfd = accept(sockfd, NULL, NULL);
    if (clientSockfd < 0) {
        printf("Failed to accept client connection\n");
        return 1;
    }

    printf("Client connected\n");

    // Read from the client
    char buffer[256];
    read(clientSockfd, buffer, sizeof(buffer));
    printf("Received: %s\n", buffer);

    // Send a response to the client
    char response[] = "Hello, client!";
    send(clientSockfd, response, strlen(response), 0);
    printf("Sent response: %s\n", response);

    // Close the client socket
    close(clientSockfd);

    return 0;
}