//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

#define DB_NAME "employees.db"

// Function to execute SQL commands
void execute_sql(sqlite3 *db, const char *sql) {
    char *err_msg = 0;
    int rc = sqlite3_exec(db, sql, 0, 0, &err_msg);

    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
    }
}

// Callback function to print the results of the query
static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to create the employee table
void create_table(sqlite3 *db) {
    const char *sql = "CREATE TABLE IF NOT EXISTS Employee(ID INTEGER PRIMARY KEY AUTOINCREMENT, Name TEXT, Age INTEGER, Department TEXT);";
    execute_sql(db, sql);
}

// Function to insert a new employee
void insert_employee(sqlite3 *db, const char *name, int age, const char *department) {
    char sql[256];
    snprintf(sql, sizeof(sql), "INSERT INTO Employee (Name, Age, Department) VALUES ('%s', %d, '%s');", name, age, department);
    execute_sql(db, sql);
}

// Function to display all employees
void display_employees(sqlite3 *db) {
    const char *sql = "SELECT * FROM Employee;";
    printf("Employee Records:\n");
    execute_sql(db, sql);
    sqlite3_exec(db, sql, callback, 0, 0);
}

int main() {
    sqlite3 *db;

    // Open database
    int rc = sqlite3_open(DB_NAME, &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    } else {
        fprintf(stderr, "Opened database successfully\n");
    }

    // Create table
    create_table(db);

    // Insert employees
    insert_employee(db, "Alice Smith", 30, "Engineering");
    insert_employee(db, "Bob Johnson", 25, "Marketing");
    insert_employee(db, "Charlie Brown", 28, "Sales");

    // Display employees
    display_employees(db);

    // Update an employee's department
    execute_sql(db, "UPDATE Employee SET Department = 'HR' WHERE Name = 'Alice Smith';");

    // Display employees after update
    printf("After update:\n");
    display_employees(db);

    // Delete an employee
    execute_sql(db, "DELETE FROM Employee WHERE Name = 'Bob Johnson';");

    // Display employees after deletion
    printf("After deletion:\n");
    display_employees(db);

    // Close the database
    sqlite3_close(db);
    return 0;
}