//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ENTRIES 1000

typedef struct {
    char name[50];
    char phone[15];
} entry;

void add_entry(entry* phonebook, int* num_entries, char* name, char* phone) {
    if (*num_entries >= MAX_ENTRIES) {
        printf("Phone book is full.\n");
        return;
    }

    strcpy(phonebook[*num_entries].name, name);
    strcpy(phonebook[*num_entries].phone, phone);

    (*num_entries)++;
}

void search_entry(entry* phonebook, int num_entries, char* name) {
    int i;

    for (i = 0; i < num_entries; i++) {
        if (strcmp(phonebook[i].name, name) == 0) {
            printf("Name: %s\nPhone: %s\n", phonebook[i].name, phonebook[i].phone);
            return;
        }
    }

    printf("Entry not found.\n");
}

void delete_entry(entry* phonebook, int* num_entries, char* name) {
    int i;

    for (i = 0; i < *num_entries; i++) {
        if (strcmp(phonebook[i].name, name) == 0) {
            memmove(&phonebook[i], &phonebook[i+1], sizeof(entry) * (*num_entries - i - 1));
            (*num_entries)--;
            return;
        }
    }

    printf("Entry not found.\n");
}

int main() {
    entry phonebook[MAX_ENTRIES];
    int num_entries = 0;

    add_entry(phonebook, &num_entries, "John Doe", "123-4567");
    add_entry(phonebook, &num_entries, "Jane Doe", "234-5678");

    search_entry(phonebook, num_entries, "John Doe");
    delete_entry(phonebook, &num_entries, "Jane Doe");

    return 0;
}