//Falcon-180B DATASET v1.0 Category: Internet Speed Test Application ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <time.h>

#define SERVER "speedtest.net"
#define PORT 8080
#define BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int sock;
    struct sockaddr_in server_addr;
    char *message = "GET /speedtest HTTP/1.1\r\nHost: speedtest.net\r\nConnection: close\r\n\r\n";
    char response[BUFFER_SIZE];
    int response_len;

    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        printf("Error creating socket\n");
        return 1;
    }

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, SERVER, &server_addr.sin_addr);

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        printf("Error connecting to server\n");
        close(sock);
        return 1;
    }

    send(sock, message, strlen(message), 0);

    response_len = recv(sock, response, BUFFER_SIZE, 0);
    if (response_len <= 0) {
        printf("Error receiving response\n");
        close(sock);
        return 1;
    }

    close(sock);

    printf("Response:\n%s", response);

    return 0;
}