//Falcon2-11B DATASET v1.0 Category: Password Strength Checker ; Style: curious
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdbool.h>

#define MIN_LENGTH 8
#define MAX_LENGTH 32

bool is_lowercase(char c) {
    return islower(c);
}

bool is_uppercase(char c) {
    return isupper(c);
}

bool is_digit(char c) {
    return isdigit(c);
}

bool is_special(char c) {
    return (c == '$' || c == '@' || c == '#' || c == '!' || c == '&' || c == '*' || c == '?' || c == '+' || c == '-' || c == '=' || c == '|' || c == '_' || c == '~');
}

bool is_valid_password(char *password) {
    int length = strlen(password);
    if (length < MIN_LENGTH || length > MAX_LENGTH) {
        return false;
    }

    bool has_lowercase = false;
    bool has_uppercase = false;
    bool has_digit = false;
    bool has_special = false;

    for (int i = 0; i < length; i++) {
        char c = password[i];
        if (is_lowercase(c)) {
            has_lowercase = true;
        }
        if (is_uppercase(c)) {
            has_uppercase = true;
        }
        if (is_digit(c)) {
            has_digit = true;
        }
        if (is_special(c)) {
            has_special = true;
        }
    }

    if (!has_lowercase ||!has_uppercase ||!has_digit ||!has_special) {
        return false;
    }

    return true;
}

int main() {
    char password[MAX_LENGTH];
    printf("Enter a password: ");
    fgets(password, sizeof(password), stdin);
    password[strcspn(password, "\n")] = '\0'; // remove newline character

    if (is_valid_password(password)) {
        printf("Strong password\n");
    } else {
        printf("Weak password\n");
    }

    return 0;
}