//GEMINI-pro DATASET v1.0 Category: Modern Encryption ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define KEY_SIZE 256
#define BLOCK_SIZE 16

typedef unsigned char byte;

void generate_key(byte *key) {
  srand(time(NULL));
  for (int i = 0; i < KEY_SIZE; i++) {
    key[i] = rand() % 256;
  }
}

void encrypt_block(byte *block, byte *key) {
  for (int i = 0; i < BLOCK_SIZE; i++) {
    block[i] ^= key[i];
  }
}

void decrypt_block(byte *block, byte *key) {
  for (int i = 0; i < BLOCK_SIZE; i++) {
    block[i] ^= key[i];
  }
}

int main() {
  byte key[KEY_SIZE];
  byte plaintext[BLOCK_SIZE] = "Hello, world!";
  byte ciphertext[BLOCK_SIZE];

  generate_key(key);

  printf("Plaintext: %s\n", plaintext);

  encrypt_block(ciphertext, key);

  printf("Ciphertext: ");
  for (int i = 0; i < BLOCK_SIZE; i++) {
    printf("%02X", ciphertext[i]);
  }
  printf("\n");

  decrypt_block(ciphertext, key);

  printf("Decrypted plaintext: %s\n", ciphertext);

  return 0;
}