//Falcon-180B DATASET v1.0 Category: Encryption ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define KEY_SIZE 10
#define BLOCK_SIZE 16

void generate_key(char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < KEY_SIZE; i++) {
        key[i] = rand() % 26 + 'a';
    }
}

void encrypt(char plaintext[BLOCK_SIZE], char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < BLOCK_SIZE; i++) {
        plaintext[i] = toupper(plaintext[i]);
        if (isalpha(plaintext[i])) {
            plaintext[i] = (char) (((int) plaintext[i] - 65 + (int) key[i % KEY_SIZE]) % 26 + 65);
        }
    }
}

void decrypt(char ciphertext[BLOCK_SIZE], char key[KEY_SIZE]) {
    int i;
    for (i = 0; i < BLOCK_SIZE; i++) {
        ciphertext[i] = toupper(ciphertext[i]);
        if (isalpha(ciphertext[i])) {
            ciphertext[i] = (char) (((int) ciphertext[i] - 65 - (int) key[i % KEY_SIZE] + 26) % 26 + 65);
        }
    }
}

int main() {
    char plaintext[BLOCK_SIZE] = "Hello, World!";
    char ciphertext[BLOCK_SIZE];
    char key[KEY_SIZE];
    int choice;

    generate_key(key);
    encrypt(plaintext, key);
    printf("Encrypted message: %s\n", plaintext);

    decrypt(plaintext, key);
    printf("Decrypted message: %s\n", plaintext);

    return 0;
}