//GPT-4o-mini DATASET v1.0 Category: Internet Speed Test Application ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#define VILLAGE_NAME "Internetville"
#define KNIGHT_NAME "Sir Bandwidth"
#define DISTANCE_TO_TOWER 100 // in meters
#define NUMBER_OF_TRIALS 5
#define MAX_SPEED 1000 // Max speed in Mbps
#define MIN_SPEED 10   // Min speed in Mbps

typedef enum {
    CONNECTED,
    DISCONNECTED
} Status;

typedef struct {
    char name[50];
    Status connection_status;
    int speed; // speed in Mbps
} Knight;

void initialize_knight(Knight* knight) {
    strcpy(knight->name, KNIGHT_NAME);
    knight->connection_status = DISCONNECTED;
    knight->speed = 0;
}

void establish_connection(Knight* knight) {
    printf("Hark! %s is attempting to connect to the internet of %s...\n", knight->name, VILLAGE_NAME);
    sleep(1);
    knight->connection_status = CONNECTED;
    printf("Connection established! %s is now connected to the magical realms of the internet!\n", knight->name);
}

void disconnect(Knight* knight) {
    printf("%s is disconnecting from the internet...\n", knight->name);
    sleep(1);
    knight->connection_status = DISCONNECTED;
    printf("Farewell from the digital land! %s is now disconnected.\n", knight->name);
}

int perform_speed_test() {
    srand(time(NULL)); // Seed for randomness
    return (rand() % (MAX_SPEED - MIN_SPEED + 1)) + MIN_SPEED; // Random speed between MIN_SPEED and MAX_SPEED
}

void conduct_speed_test(Knight* knight) {
    if (knight->connection_status == CONNECTED) {
        printf("%s is conducting the noble speed test...\n", knight->name);
        sleep(2);

        int total_speed = 0;
        for (int i = 0; i < NUMBER_OF_TRIALS; i++) {
            printf("Trial %d: The magical wind is carrying the data...\n", i + 1);
            int speed = perform_speed_test();
            printf("Trial %d completed! Speed: %d Mbps\n", i + 1, speed);
            total_speed += speed;
            sleep(1);
        }

        knight->speed = total_speed / NUMBER_OF_TRIALS; // Average speed
        printf("The average speed of %s's connection is: %d Mbps!\n", knight->name, knight->speed);
    } else {
        printf("Alas! %s cannot conduct the speed test while disconnected from the internet.\n", knight->name);
    }
}

void display_status(Knight* knight) {
    printf("Knight's Name: %s\n", knight->name);
    printf("Connection Status: %s\n", knight->connection_status == CONNECTED ? "Connected" : "Disconnected");
    printf("Current Speed: %d Mbps\n", knight->speed);
}

int main() {
    printf("Welcome, brave souls of %s!\n", VILLAGE_NAME);

    Knight knight;
    initialize_knight(&knight);

    establish_connection(&knight);
    display_status(&knight);

    conduct_speed_test(&knight);
    
    disconnect(&knight);
    display_status(&knight);

    printf("The realm of %s bids thee farewell!\n", VILLAGE_NAME);
    return 0;
}