//Falcon-180B DATASET v1.0 Category: Cryptography Implementation ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_KEY_SIZE 16
#define MAX_BLOCK_SIZE 8

// Key generation function
void generate_key(unsigned char key[MAX_KEY_SIZE])
{
    for (int i = 0; i < MAX_KEY_SIZE; i++)
    {
        key[i] = rand() % 256;
    }
}

// Encryption function
void encrypt(unsigned char key[MAX_KEY_SIZE], unsigned char plaintext[MAX_BLOCK_SIZE], unsigned char ciphertext[MAX_BLOCK_SIZE])
{
    for (int i = 0; i < MAX_BLOCK_SIZE; i++)
    {
        ciphertext[i] = plaintext[i] ^ key[i % MAX_KEY_SIZE];
    }
}

// Decryption function
void decrypt(unsigned char key[MAX_KEY_SIZE], unsigned char ciphertext[MAX_BLOCK_SIZE], unsigned char plaintext[MAX_BLOCK_SIZE])
{
    for (int i = 0; i < MAX_BLOCK_SIZE; i++)
    {
        plaintext[i] = ciphertext[i] ^ key[i % MAX_KEY_SIZE];
    }
}

int main()
{
    srand(time(NULL));

    unsigned char key[MAX_KEY_SIZE];
    generate_key(key);

    unsigned char plaintext[MAX_BLOCK_SIZE] = { 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48 };
    unsigned char ciphertext[MAX_BLOCK_SIZE];

    encrypt(key, plaintext, ciphertext);

    for (int i = 0; i < MAX_BLOCK_SIZE; i++)
    {
        printf("%02X ", ciphertext[i]);
    }
    printf("\n");

    decrypt(key, ciphertext, plaintext);

    for (int i = 0; i < MAX_BLOCK_SIZE; i++)
    {
        printf("%c", plaintext[i]);
    }

    return 0;
}