//Code Llama-13B DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define PORT 8080
#define MAXBUF 1024

int main(int argc, char **argv) {
    int sockfd, newsockfd, n;
    char buffer[MAXBUF];
    struct sockaddr_in serv_addr, cli_addr;
    socklen_t cli_len = sizeof(cli_addr);

    // create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    // initialize server address
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    // bind socket
    if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("ERROR on binding");
        exit(1);
    }

    // listen for incoming connections
    listen(sockfd, 5);

    // accept incoming connections
    newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &cli_len);
    if (newsockfd < 0) {
        perror("ERROR on accept");
        exit(1);
    }

    // receive incoming data
    bzero(buffer, MAXBUF);
    n = read(newsockfd, buffer, MAXBUF);
    if (n < 0) {
        perror("ERROR reading from socket");
        exit(1);
    }

    // print incoming data
    printf("Received %d bytes from client: %s\n", n, buffer);

    // send response to client
    n = write(newsockfd, "Thank you for connecting", 18);
    if (n < 0) {
        perror("ERROR writing to socket");
        exit(1);
    }

    // close socket
    close(newsockfd);
    close(sockfd);

    return 0;
}