//GPT-4o-mini DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define MAX_BAGS 10
#define BAG_NAME_LENGTH 20

typedef struct {
    char name[BAG_NAME_LENGTH];
} Bag;

typedef struct {
    Bag bags[MAX_BAGS];
    int front;
    int rear;
    int size;
} Queue;

void initQueue(Queue* q) {
    q->front = 0;
    q->rear = -1;
    q->size = 0;
}

int isFull(Queue* q) {
    return q->size == MAX_BAGS;
}

int isEmpty(Queue* q) {
    return q->size == 0;
}

void enqueue(Queue* q, Bag bag) {
    if (!isFull(q)) {
        q->rear = (q->rear + 1) % MAX_BAGS;
        q->bags[q->rear] = bag;
        q->size++;
    } else {
        printf("Queue is full! Cannot add bag: %s\n", bag.name);
    }
}

Bag dequeue(Queue* q) {
    Bag bag = {"EMPTY"};
    if (!isEmpty(q)) {
        bag = q->bags[q->front];
        q->front = (q->front + 1) % MAX_BAGS;
        q->size--;
    } else {
        printf("Queue is empty! Cannot remove bag.\n");
    }
    return bag;
}

void displayQueue(Queue* q) {
    if (isEmpty(q)) {
        printf("No bags in the queue.\n");
        return;
    }
    printf("Bags in queue:\n");
    for (int i = 0; i < q->size; i++) {
        int index = (q->front + i) % MAX_BAGS;
        printf("  %s\n", q->bags[index].name);
    }
}

void simulateBaggageHandling(Queue* q) {
    while (!isEmpty(q)) {
        Bag currentBag = dequeue(q);
        printf("Processing bag: %s\n", currentBag.name);
        sleep(1); // Simulating processing time
        printf("Bag %s has been loaded onto the conveyor belt.\n", currentBag.name);
    }
}

void generateBags(Queue* q) {
    const char* bagNames[] = {"Bag1", "Bag2", "Bag3", "Bag4", "Bag5"};
    for (int i = 0; i < 5; i++) {
        Bag newBag;
        strncpy(newBag.name, bagNames[i], BAG_NAME_LENGTH);
        enqueue(q, newBag);
    }
}

int main() {
    Queue baggageQueue;
    initQueue(&baggageQueue);

    printf("=== Airport Baggage Handling Simulation ===\n");
    generateBags(&baggageQueue);
    displayQueue(&baggageQueue);

    printf("Starting baggage handling...\n");
    simulateBaggageHandling(&baggageQueue);

    printf("All bags have been processed. Simulation finished.\n");
    
    return 0;
}