//GEMINI-pro DATASET v1.0 Category: RAM usage monitor ; Style: scalable
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/sysinfo.h>

// Get the size of the physical memory in bytes
size_t get_physical_memory_size() {
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    perror("sysinfo");
    return 0;
  }
  return info.totalram;
}

// Get the size of the used physical memory in bytes
size_t get_used_physical_memory_size() {
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    perror("sysinfo");
    return 0;
  }
  return info.totalram - info.freeram;
}

// Get the size of the free physical memory in bytes
size_t get_free_physical_memory_size() {
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    perror("sysinfo");
    return 0;
  }
  return info.freeram;
}

// Get the size of the shared physical memory in bytes
size_t get_shared_physical_memory_size() {
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    perror("sysinfo");
    return 0;
  }
  return info.sharedram;
}

// Get the size of the buffer physical memory in bytes
size_t get_buffer_physical_memory_size() {
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    perror("sysinfo");
    return 0;
  }
  return info.bufferram;
}

// Get the size of the cached physical memory in bytes
size_t get_cached_physical_memory_size() {
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    perror("sysinfo");
    return 0;
  }
  return info.totalswap - info.freeswap;
}

// Print the RAM usage information
void print_ram_usage() {
  printf("Physical Memory Size: %lu bytes\n", get_physical_memory_size());
  printf("Used Physical Memory Size: %lu bytes\n", get_used_physical_memory_size());
  printf("Free Physical Memory Size: %lu bytes\n", get_free_physical_memory_size());
  printf("Shared Physical Memory Size: %lu bytes\n", get_shared_physical_memory_size());
  printf("Buffer Physical Memory Size: %lu bytes\n", get_buffer_physical_memory_size());
  printf("Cached Physical Memory Size: %lu bytes\n", get_cached_physical_memory_size());
}

int main() {
  print_ram_usage();
  return 0;
}