//Gemma-7B DATASET v1.0 Category: Movie Rating System ; Style: active
#include <stdio.h>
#include <stdlib.h>

// Define a struct to store movie information
typedef struct Movie {
    char title[50];
    int year;
    float rating;
} Movie;

// Function to compare movies by rating
int compareMoviesByRating(Movie* a, Movie* b) {
    return (int)a->rating - (int)b->rating;
}

// Function to compare movies by title
int compareMoviesByTitle(Movie* a, Movie* b) {
    return strcmp(a->title, b->title);
}

// Function to print movie information
void printMovieInformation(Movie* m) {
    printf("Title: %s\n", m->title);
    printf("Year: %d\n", m->year);
    printf("Rating: %.1f\n", m->rating);
}

int main() {
    // Create an array of movies
    Movie movies[] = {
        {"The Shawshank Redemption", 1994, 9.3},
        {"The Godfather", 1972, 9.2},
        {"The Dark Knight", 2008, 9.0},
        {"The Lord of the Rings: The Fellowship of the Ring", 2001, 8.9},
        {"The Matrix Reloaded", 2003, 8.7}
    };

    // Sort the movies by rating
    qsort(movies, 5, sizeof(Movie), compareMoviesByRating);

    // Print the sorted movies
    for (int i = 0; i < 5; i++) {
        printMovieInformation(&movies[i]);
    }

    // Sort the movies by title
    qsort(movies, 5, sizeof(Movie), compareMoviesByTitle);

    // Print the sorted movies
    for (int i = 0; i < 5; i++) {
        printMovieInformation(&movies[i]);
    }

    return 0;
}